unit GistogramService02;
(*
   ========================================================================
    Gistogram
          .
   ========================================================================
       ,   
       .
   : BitMap.PixelFormat = pf24bit
   ========================================================================
   ()  ,    , , .
   ========================================================================
*)
interface
uses Windows, Messages, SysUtils, Classes, Graphics,
     Controls, Dialogs, Math,
     MainData,
     VisualPointEditor01;

//     
function LoadFuncFromFile(RqOpenDialog : TOpenDialog) : TPointArray;

//     
procedure SaveFuncToFile(RqSaveDialog : TSaveDialog; RqPArr : TPointArray);

//       
function TestFuncDirectory() : boolean;


implementation


const FuncSubDir = '\Functions';
const MSeparator = #09;  // 

//    
var BufArr : array of record
    fBusy  : boolean;
    fError : boolean;
    X      : integer;
    Y      : integer;
    end;

//  
var XLErrCt, YLErrCt : integer;

// -------------------------------------------------------------------------
//       
function StrTextToInt (Text : string; var Digit : integer) : boolean;
begin
  Result := False;
  try Digit := StrToInt(Text);
      Result := True;
  except Digit := 0;
  end;
end;
// -------------------------------------------------------------------------
//  X  Y         
procedure OneStrToBufArr (RqIndA : integer; RqSep, RqStr : string);
var  wPos : integer;
     wStr : string;
     wInt : integer;
begin
  //     
  BufArr[RqIndA].fBusy := False;
  //   
  // Pos = 0    
  // Pos = 1        
  wPos := Pos(RqSep, RqStr);
  if wPos > 1
  then begin
    //   ,    
    wStr := Trim(Copy(RqStr, 1, wPos - 1));
    if wStr <> ''
    then begin
       //    X.   X
       if StrTextToInt(wStr, wInt)
       then BufArr[RqIndA].X := wInt
       else begin
          BufArr[RqIndA].fError := True;
          Inc(XLErrCt);
       end;
    end;
    //     
    wStr := RqStr;
    Delete(wStr, 1, wPos);
    wStr := Trim(wStr);
    if wStr <> ''
    then begin
       //    Y.   Y
       if StrTextToInt(wStr, wInt)
       then BufArr[RqIndA].Y  := wInt
       else begin
          BufArr[RqIndA].fError := True;
          Inc(YLErrCt);
       end;
    end;
    //   ,     
    if not BufArr[RqIndA].fError
    then BufArr[RqIndA].fBusy := True;
  end;
end;
// -------------------------------------------------------------------------
//    
function LoadTxtToBufArr (RqSep : string; RqList : TStringList) : boolean;
var IndA : integer;   //     BufArr
    IndL : integer;   //     RqList
    wStr : string;
begin
   Result := False;
   //   
   XLErrCt := 0; YLErrCt := 0;
   //     RqList
   IndL := 0;
   for IndA := Low(BufArr) to High(BufArr)
   do begin
     //      RqList
     wStr := '';
     if IndL <= (RqList.Count - 1)
     then begin
       repeat
         wStr := Trim(RqList.Strings[IndL]);
         //  
         if Length(wStr) > 0 then if wStr[1] ='/' then wStr := '';
         Inc(IndL);
       until wStr <> '';
     end;
     //  X  Y   
     if wStr <> ''
     then begin
       OneStrToBufArr (IndA, RqSep, wStr);
     end;
   end;
   if (XLErrCt = 0) and (YLErrCt = 0)
   then Result := True;                //  
end;

// -------------------------------------------------------------------------
//      
function RunLoadFuncFromFile (RqFileName : string;
                              RqSep      : string) : boolean;
//    
var wList : TStringList;
    Ind   : integer;
begin
  Result := False;
  wList  := nil;
  try
    wList  := TStringList.Create;       //    
    wList.LoadFromFile(RqFileName);     //    
    if wList.Count > 0
    then begin
       //   
       SetLength(BufArr, wList.Count);
       //    
       for Ind := 0 to High(BufArr)
       do begin
          BufArr[Ind].fError := False;  //    
          BufArr[Ind].fBusy  := False;  //   
       end;
       //  
       if LoadTxtToBufArr (RqSep, wList)
       then Result := True;             //  
    end;
  finally
     if wList <> nil then wList.Free;
  end;
end;
// -------------------------------------------------------------------------
//     
function LoadFuncFromFile(RqOpenDialog : TOpenDialog) : TPointArray;
var WInd  : integer;
    BCT  : integer;
    RInd : integer;
begin
   //     
   if AppDirectory <> ''
   then RqOpenDialog.InitialDir := AppDirectory + FuncSubDir
   else RqOpenDialog.InitialDir := '.' + FuncSubDir;
  RqOpenDialog.Filter := '  (*.fcc)|*.fcc';
  if RqOpenDialog.Execute
  then begin

     //       
     if RunLoadFuncFromFile (RqOpenDialog.FileName, MSeparator)
     then begin
       //   
       SetLength (Result, 0);
       //      
       BCT := 0;
       for WInd := 0 to High(BufArr)
       do if BufArr[WInd].fBusy then BCT := BCT + 1;
       if BCT > 0
       then begin
         //       Result
         SetLength (Result, BCT);
         RInd := 0;
         for WInd := 0 to High(BufArr)
         do if BufArr[WInd].fBusy
            then begin
              with BufArr[WInd]
              do begin
                //    
                if X < 0   then X := 0;
                if X > 255 then X := 255;
                if Y < 0   then Y := 0;
                if Y > 255 then Y := 255;
                //  
                Result[RInd].X := X;
                Result[RInd].Y := Y;
              end;
              RInd := RInd + 1;
            end;
       end;
     end
     else begin  // 
       MessageDlg('     :'
                   + #13#10 + '    - ' + IntToStr(XLErrCt)
                   + #13#10 + '   - ' + IntToStr(YLErrCt)
                   + #13#10 + '  ',
                   mtWarning, [mbYes], 0);
     end;
  end;
end;
// -------------------------------------------------------------------------
//   
procedure RunSaveFuncToFile (RqFileName : string;
                             RqPArr : TPointArray;
                             RqSep : char);
var wList : TStringList;
    Ind   : integer;
begin
  if Length(RqPArr) = 0 then Exit;
  // 
  wList := nil;
  try
    wList  := TStringList.Create;     //    
    for Ind := 0 to High(RqPArr)
    do wList.Add(IntToStr(RqPArr[Ind].X) + RqSep + IntToStr(RqPArr[Ind].Y));
    wList.SaveToFile(RqFileName);
  finally
     if wList <> nil then wList.Free;
  end;
end;
// -------------------------------------------------------------------------
//     
procedure SaveFuncToFile(RqSaveDialog : TSaveDialog; RqPArr : TPointArray);
var FileName, FileExt : string;
begin
  //     
  if AppDirectory <> ''
  then RqSaveDialog.InitialDir := AppDirectory + FuncSubDir
  else RqSaveDialog.InitialDir := '.' + FuncSubDir;
  RqSaveDialog.Filter := '  (*.fcc)|*.fcc';
  if RqSaveDialog.Execute
  then begin
    FileName := RqSaveDialog.FileName;
    if FileName <> ''
    then begin
       FileExt := UpperCase(ExtractFileExt(FileName));
       //     ,    
       if (FileExt <> 'FCC') then FileName := FileName + '.fcc';
       //   
       if FileExists(FileName)
       then begin
          if MessageDlg('   .'
                        + #13#10 + '?',
                         mtConfirmation, [mbYes, mbNo], 0) = mrYes
          then RunSaveFuncToFile (FileName, RqPArr, MSeparator);

       end
       else RunSaveFuncToFile (FileName, RqPArr, MSeparator);
    end;
  end;
end; // of procedure
// -------------------------------------------------------------------------
// 04.02.2013
//       
function TestFuncDirectory () : boolean;
var   WDir : string;
begin
  Result := False;
  if AppDirectory <> ''
  then WDir := AppDirectory + FuncSubDir
  else WDir := '.' + FuncSubDir;
  if not DirectoryExists(WDir)
  then begin
    try
      CreateDir(WDir);
      Result := True;
    except
      MessageDlg('    :   *.fcc : '
                 + #13#10 + WDir,
                  mtWarning, [mbOk], 0);
    end;
  end
  else Result := True;
end;


end.
